/*
 * Buzz parameter interface, see params.h for more information
 *
 * History
 * Date       Version    Programmer         Comments
 * 16/2/03    1.0        Darrell Tam		Created
 */

#include "StdAfx.h"
#include "ParamDesc.h"
#include "BlkFxProcess.h"
#include "MIBlkFx.h"
#include "params.h"

using namespace std;

//------------------------------------------------------------------------------------------
// any descriptions which call MIBlkFx are here
void _FreqParam::desc(char* txt, MIBlkFx& i) const
{
	float freq = i.roundFreqDisp(getHz());

	if(freq < 1000.0f) txt += sprintf(txt, "%.0fHz,", freq);
	else if(freq < 10000.0f) txt += sprintf(txt, "%.2fkHz,", freq*1e-3);
	else txt += sprintf(txt, "%.1fkHz,", freq*1e-3f);
	HzToNote(txt, freq);
}

void EffectTrkParam::desc(char* txt, MIBlkFx& i) const
{
	strcpy(txt, BlkFxProcess::name(limitGet()));
}

void BlkLenParam::desc(char* txt, MIBlkFx& i) const
{
	sprintf(txt, "%d", BLK_SZ_0 << i.getBlkLenDisp(limitGet()));
}

#define PARAM(CLASS, NAME) NAME.update(b.NAME);
//------------------------------------------------------------------------------------------
void Params::TVals::update(const TVals& b)
{
	TRK_PARAMS
}

//------------------------------------------------------------------------------------------
void Params::update(const Params& b)
{
	tv_n = b.tv_n;
	GLOBAL_PARAMS
	for(int i = 0; i < tv_n; i++) tv[i].update(b.tv[i]);
}
#undef PARAM

//------------------------------------------------------------------------------------------
ParamsVec::ParamsVec()
{
	v.resize(128); // arbitary initial size
	reset();
}

//------------------------------------------------------------------------------------------
void ParamsVec::reset(void)
{
	in = &v[0];
	in->copy(Params());
	in->pos_abs = 0;
	in->tv_n = 0;
	in->samps_per_tick = -1; // tag as initialParam

	curr = &v[0];
	next = curr;
}


//------------------------------------------------------------------------------------------
void ParamsVec::incOutPos(void)
// go to the next output
{
	if(++curr == v.end()) curr = &v[0]; // wrap

	next = curr+1;
	if(next == v.end()) next = &v[0]; // wrap

	filled_prev = filled_curr;
	filled_curr.update(*curr);
	tick_frac = 0.0f;
}


