#include "StdAfx.h"
#include "MIBlkFxCommon.h"
#include "MIBlkFx.h"
#include "BlkFxDialog.h"

//------------------------------------------------------------------------------------------
MIBlkFxCommon::MIBlkFxCommon()
{
	mi = NULL;
	dialog = NULL;
	dialog_ready = false;
}

//------------------------------------------------------------------------------------------
void MIBlkFxCommon::createDialog()
//
// open the dialog or bring it to the front if it already exists
//
{
	ScopeCriticalSection lock(protection);
	if(!mi) return;

	if(dialog) {
		dialog->BringWindowToTop();
		dialog->ShowWindow(SW_RESTORE);
		return;
	}
	dialog = new BlkFxDialog(this, CWnd::FromHandle(GetActiveWindow()));
	dialog->Create(BlkFxDialog::IDD);
	dialog->SetWindowText(mi->getMachineName());
	dialog_ready = true;
}

//------------------------------------------------------------------------------------------
void MIBlkFxCommon::updateControls()
//
// send a windows message to update the GUI window (if it's open)
//
{
	if(!dialog_ready) return; // reduce number of locks by checking first
	ScopeCriticalSection lock(protection);

	if(dialog) {
		dialog->sgram[1].setHorizLine(mi->getOutPosAbs());
		dialog->PostMessage(BlkFxDialog::UPDATE_CONTROLS, 0, 0);
	}
}

//------------------------------------------------------------------------------------------
void MIBlkFxCommon::sgramData(int sgram_num, long abs_pos, int/*log2(fft_blk_len/BLK_SZ_0)*/n, pcplxf in)
//
// pass new data to the dialog spectrogram (if it's open)
//
{
	if(!dialog_ready) return; // try to reduce number of locks by checking first
	ScopeCriticalSection lock(protection);
	if(dialog) dialog->sgram[sgram_num].newData(abs_pos, n, in);
}
