// DtSliderBase.cpp : implementation file
//

#include "stdafx.h"
#include "misc_stuff.h"
#include "DtSliderBase.h"
#include "DtMfcStuff.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(DtSliderBase, DtCtrl)
	//{{AFX_MSG_MAP(DtSliderBase)
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//----------------------------------------------------------------------------------------------------
DtSliderBase::Slider::Slider() : knob_state(INACTIVE), screen_pos(0)
{
	value = 0.0f;
	click_delta = 0;
}

//----------------------------------------------------------------------------------------------------
DtSliderBase::Slider::~Slider()
{
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::Slider::nudge(float mouse_val, float move_frac)
{
	float new_value = value;
	if(value > mouse_val) {
		new_value -= move_frac;
		if(new_value < mouse_val) new_value = mouse_val;
	}
	else if(value < mouse_val) {
		new_value += move_frac;
		if(new_value > mouse_val) new_value = mouse_val;
	}
	value = limit_range(new_value, 0.0f, 1.0f);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::Slider::drag(float mouse_val)
{
	value = limit_range(mouse_val-click_delta, 0.0f, 1.0f);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::Slider::setClickDelta(int x, int window_width)
{
	click_delta = (float)(x-screen_pos)/(window_width-1);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::Slider::select(CPoint p)
// Select knob, direct adjust if cursor is close enough otherwise nudge
{
	if(p.x > screen_pos-10 && p.x < screen_pos+10) knob_state = DIRECT_ADJUST;
	else knob_state = TIMER_NUDGE;
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::Slider::deselect(void)
{
	knob_state = INACTIVE;
}

/////////////////////////////////////////////////////////////////////////////
// DtSliderBase

DtSliderBase::DtSliderBase()
{
	parent_intercept_keys = false;

	edit_lock = false;

	// set default knob colours
	knob_state_colour[Slider::INACTIVE] = 0x0000a0UL;
	knob_state_colour[Slider::TIMER_NUDGE] = 0x0000ffUL;
	knob_state_colour[Slider::DIRECT_ADJUST] = 0x6060ffUL;

	edit_state_colour[Slider::INACTIVE] = 0x6060ffUL;
	edit_state_colour[Slider::TIMER_NUDGE] = 0xffffffUL;
	edit_state_colour[Slider::DIRECT_ADJUST] = 0xffffffUL;
}

//----------------------------------------------------------------------------------------------------
DtSliderBase::~DtSliderBase()
{
}

//----------------------------------------------------------------------------------------------------
COLORREF DtSliderBase::knobStateColour(int slider)
{
	return knob_state_colour[
		limit_range((int)s[slider]->knob_state, 0, (int)Slider::N_STATES-1)
	];
}

//----------------------------------------------------------------------------------------------------
COLORREF DtSliderBase::editStateColour(int slider)
{
	return edit_state_colour[
		limit_range((int)s[slider]->knob_state, 0, (int)Slider::N_STATES-1)
	];
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::setNumSliders(int n, bool alloc_sliders)
{
	s.resize(n);
	_temp.resize(n);

	// use default slider structure
	if(alloc_sliders)
		for(int i = 0; i < n; i++) s[i] = new_auto_ptr<Slider>();
}

//----------------------------------------------------------------------------------------------------
bool DtSliderBase::setEditText(int slider, int edit_num, const string& str, bool force)
// don't set the text if the user is typing into the edit
{
	if(!force && edit_lock && s[slider]->isActive() && edit_num==s[slider]->medit.getActiveN())
		return false;
	s[slider]->medit(edit_num).setText(str);
	return true;
}


//----------------------------------------------------------------------------------------------------
int/*slider*/DtSliderBase::getActive(void)
// return which slider is active
{
	int r = -1;
	for(int i=0; i < s.size(); i++) if(s[i]->isActive()) {
		if(r!=-1) return -1;
		r=i;
	}
	return r;
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::prepareDrawText(CSize* /*out*/ sz)
//
// prepare to draw the multi edits - update the font & colour
// must be called prior to drawCursor() or drawText()
//
// sz array is filled with pixel size of each multiedit, caller must supply enough space for
// the number of sliders
{
	int i;

	// check whether the font needs to be updated
	if(font.update()) {
		for(i = 0; i < s.size(); i++)
			s[i]->medit.setFont(font);
	}

	for(i = 0; i < s.size(); i++) {
		// set the multi edit colour based on knob states
		bool is_active = s[i]->isActive();
		
		s[i]->medit.setColour(editStateColour(i), 0x000000UL);
		s[i]->medit.cursorVisible(is_active);

		DtEdit& edit = s[i]->medit();
		if(is_active && !edit_lock && !edit.isAllSelected()) edit.selectAll(true);

		// get the size of the multi-edit
		sz[i] = s[i]->medit.size(mem_dc);
	}
}


//----------------------------------------------------------------------------------------------------
void DtSliderBase::drawCursor(CPoint* p)
// precondition: prepareDrawText() must have been called
{
	for(int i = 0; i < s.size(); i++) {
		if(s[i]->medit.cursorVisible())
			s[i]->medit.drawCursor(mem_dc, p[i]);
	}
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::drawText(CPoint* p)
// precondition: prepareDrawText() must have been called
{
	for(int i = 0; i < s.size(); i++)
		s[i]->medit.drawText(mem_dc, p[i]);
}


//----------------------------------------------------------------------------------------------------
void DtSliderBase::selectSlider(int n)
// select slider "n" and deactivate all others
{
	// different slider? turn off edit lock
	if(!s[n]->isActive()) edit_lock = false;

	for(int i = 0; i < s.size(); i++) {
		if(i==n) s[i]->select(curr_point);
		else s[i]->deselect();
	}
}

//----------------------------------------------------------------------------------------------------
bool DtSliderBase::chkRedraw(float* /*vector of screen positions 0..1*/ v)
//
// Call from parent to set screen position of slider & determine whether to call redraw
//
{
	bool redraw = force_redraw;
	
	// check whether anything needs update
	for(int i = 0; i < s.size(); i++) {
		s[i]->screen_pos = v[i]*(client_rect.Width()-1)+0.5f;
		s[i]->screen_pos.update(redraw);
		s[i]->knob_state.update(redraw);
		if(s[i]->medit.requireRedraw()) redraw = true;
	}
	if(font.curr != font.next) redraw = true;
	return redraw;
}

//----------------------------------------------------------------------------------------------------
bool DtSliderBase::chkRedraw(void)
// default chkRedraw (called by DtCtrl) uses slider fractions directly as screen position
{
	for(int i = 0; i < s.size(); i++) _temp[i] = s[i]->value;
	return chkRedraw(_temp.begin());
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnMouseLeave(void)
// deactive all sliders when the mouse leaves
{
	edit_lock = false;
	for(int i = 0; i < s.size(); i++) s[i]->deselect();
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnLButtonDrag(void)
{
	for(int i = 0; i < s.size(); i++)
		if(s[i]->knob_state == Slider::DIRECT_ADJUST) s[i]->drag(mouseVal());
	sendCmdMsg(NC_USERCHG);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnRButtonDrag(void)
{
	float mouse_val = mouseVal();
	for(int i = 0; i < s.size(); i++)
		s[i]->drag(mouse_val);
	sendCmdMsg(NC_USERCHG);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnMouseMove(void)
{
	selectSlider(); // from derived class
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnLButtonDown(void)
{
	edit_lock = false;
	selectSlider(); // from derived class
	for(int i = 0; i < s.size(); i++) {
		switch(s[i]->knob_state) {
		case Slider::DIRECT_ADJUST:
			s[i]->setClickDelta(curr_point.x, client_rect.Width());
			return;
		case Slider::TIMER_NUDGE:
			SetTimer(9999, 100, NULL);
			s[i]->nudge(mouseVal(), 0.01f);
			sendCmdMsg(NC_USERCHG);
			return;
		}
	}
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnLButtonDblClk(void)
{
	OnLButtonDown();
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnLButtonUp(void)
{
	selectSlider(); // from derived class
	KillTimer(9999);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnRButtonDown(void)
{
	edit_lock = false;
	// set all sliders to direct adjust
	for(int i = 0; i < s.size(); i++) {
		s[i]->setClickDelta(curr_point.x, client_rect.Width());
		s[i]->knob_state = Slider::DIRECT_ADJUST;
	}
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnRButtonDblClk(void)
{
	OnRButtonDown();
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnRButtonUp(void)
{
	selectSlider(); // from derived class
	KillTimer(9999);
}

//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent == 9999) {
		// nudge all knobs with timer nudge enabled
		if(lbutton_down) {
			for(int i=0; i < s.size(); i++)
				if(s[i]->knob_state == Slider::TIMER_NUDGE)
					s[i]->nudge(mouseVal(), 0.005f);
			sendCmdMsg(NC_USERCHG);
			SetTimer(9999, 10, NULL);
			redrawControl();
		}
	}
	else DtCtrl::OnTimer(nIDEvent);

	CWnd::OnTimer(nIDEvent);	
}


//----------------------------------------------------------------------------------------------------
void DtSliderBase::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	bool cancel_key_press = false;
	if(parent_intercept_keys) sendCmdMsg(NC_KEYPRESS);
	if(cancel_key_press) return;

	int active = getActive();
	if(active == -1) {
		DtCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
		return;
	}

	desensitize_mouse = true;
	edit_lock = true;

	DtMultiEdit& me = s[active]->medit;
	string prev_txt = me().getText();

	me.OnKeyDown(nChar, nRepCnt, nFlags);

	if(me.getFlag(DtEditArray::FLAG_KEY_EDIT_CHANGE)) {
		// the user moved to another edit?
		edit_lock = false;

		// set all edits to have the same active
		for(int i=0; i < s.size(); i++)
			s[i]->medit.setActiveN(me.getActiveN());

		// did the edit change wrap?
		if(me.getFlag(DtEditArray::FLAG_KEY_NEXT_WRAP))
			selectSlider(wrap(active+1, s));
		else if(me.getFlag(DtEditArray::FLAG_KEY_PREV_WRAP))
			selectSlider(wrap(active-1, s));
	}
	else if(prev_txt != me().getText()) {
		// send messages if the text changed
		sendCmdMsg(NC_EDITTXTCHG);
		sendCmdMsg(NC_USERCHG);
	}
	redrawControl();
}

