/******************************************************************************
DtSlider
Single horizontal slider derived from DtSliderBase

History
	Date       Version    Programmer         Comments
	29/07/03   1.0        Darrell Tam
******************************************************************************/

#if !defined(AFX_DTSLIDER_H__CC526CA5_9077_46F1_8CBC_4E97D888F7B1__INCLUDED_)
#define AFX_DTSLIDER_H__CC526CA5_9077_46F1_8CBC_4E97D888F7B1__INCLUDED_

#include "DtSliderBase.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DtSlider.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// DtSlider window

class DtSlider : public DtSliderBase
{
public:
	DtSlider();
	virtual ~DtSlider();

public: // access to multi edit
	DtMultiEdit& multiEdit(void) { return DtSliderBase::multiEdit(0); }	
	DtMultiEdit& operator () (void) { return multiEdit(); }

	// return false if user is currently typing into edit
	bool setEditText(int edit_num, const string& s, bool force=false)
		{ return DtSliderBase::setEditText(0, edit_num, s, force); }

	bool operator () (int edit_num, const string& s, bool force=false)
		{ return setEditText(edit_num, s, force); }

public: // value access
	float/*0..1*/getVal(void) { return DtSliderBase::getVal(0); }
	void setVal(float/*0..1*/v) { DtSliderBase::setVal(0, v); }

	bool isUserChanging(void) { return DtSliderBase::isUserChanging(0); }

public: // draw methods 
	bool chkRedraw(float/*0..1*/v) { return DtSliderBase::chkRedraw(&v); }

	virtual void drawControl(void); // overridden from DtSliderBase

	virtual void selectSlider(void); // overridden from DtSliderBase

	// Generated message map functions
protected:
	//{{AFX_MSG(DtSlider)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DTSLIDER_H__CC526CA5_9077_46F1_8CBC_4E97D888F7B1__INCLUDED_)
