// DtSlider.cpp : implementation file
//

#include "stdafx.h"
#include "DtMfcStuff.h"
#include "DtSlider.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// DtSlider
BEGIN_MESSAGE_MAP(DtSlider, DtSliderBase)
	//{{AFX_MSG_MAP(DtSlider)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//----------------------------------------------------------------------------------------------------
DtSlider::DtSlider()
{
	setNumSliders(1);
}

//----------------------------------------------------------------------------------------------------
DtSlider::~DtSlider()
{
}


//----------------------------------------------------------------------------------------------------
void DtSlider::drawControl(void)
//
//
{
	// find position to draw text
	CSize text_sz;
	DtSliderBase::prepareDrawText(&text_sz);

	// determine where to draw the text
	if(!edit_lock) s[0]->draw_text_left = s[0]->value > 0.5f;
	CPoint p;
	if(s[0]->draw_text_left) p = CPoint(2, 0);
	else p = CPoint(client_rect.right-text_sz.cx-2, client_rect.bottom-text_sz.cy);

	// draw background
	int x = s[0]->screen_pos;
	int y = client_rect.Height()/2;

	{
		CPen pen1(PS_SOLID,1,0x000050);
		ScopeSelect<CPen> old_pen(mem_dc, &pen1);
		mem_dc->MoveTo(CPoint(0, y));
		mem_dc->LineTo(CPoint(client_rect.Width(), y));
	}

	CRect r;
	r.top = y-3;
	r.bottom = y+3+1;
	r.left = 0;
	r.right = x-5;
	mem_dc->FillRect(&r, &CBrush(0x000080));

	{
		CPen pen1(PS_SOLID,1,knobStateColour(0));
		ScopeSelect<CPen> old_pen(mem_dc, &pen1);
		mem_dc->MoveTo(CPoint(0, y));
		mem_dc->LineTo(CPoint(x-5, y));
	}
	
	// draw text cursor
	drawCursor(&p);

	// draw knob
	r.top = y-5;
	r.bottom = y+5+1;
	r.left = x-5;
	r.right = x+5+1;
	mem_dc->FillRect(&r, &CBrush(knobStateColour(0)));

	// draw text
	drawText(&p);
}

//----------------------------------------------------------------------------------------------------
void DtSlider::selectSlider(void)
// only one slider, always select control 0
{
	DtSliderBase::selectSlider(0);
}
