#include "StdAfx.h"
#include "DtEditArray.h"


//----------------------------------------------------------------------------------------------------
DtEditArray::DtEditArray()
{
	font = NULL;
	active_edit = 0;
	flags.resize(N_FLAGS);
}

//----------------------------------------------------------------------------------------------------
DtEditArray::~DtEditArray()
{
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::setStaticText(int i, const string& s)
{
	edit[i]->setText(s);
	skipEdit(i, true);
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::setFont(CFont* font_)
{
	font = font_;
	for(int i=0; i<edit.size(); i++) edit[i]->setFont(font);
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::setColour(COLORREF inside, COLORREF outside)
{
	for(int i=0; i<edit.size(); i++)
		edit[i]->setColour(inside, outside);
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::setActiveN(int n)
{
	active_edit = n;
	cursorVisible(cursor_visible);
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::setN(int n)
{
	int prev_size = getN();
	edit.resize(n);
	skip_edit.resize(n);
	sz.resize(n);

	for(int i = prev_size; i < n; i++) {
		edit[i] = new_auto_ptr<DtEdit>();
		if(font) edit[i]->setFont(font);
		// new edits not skipped by default
		skip_edit[i] = false;
	}
	if(n < prev_size) setActiveN(0);
}

//----------------------------------------------------------------------------------------------------
CSize DtEditArray::size(CDC *dc)
{
	CSize total(0, 0);
	for(int i = 0; i < edit.size(); i++) {
		sz[i] = edit[i]->size(dc);
		total.cx += sz[i].cx;
		if(sz[i].cy > total.cy) total.cy = sz[i].cy;
	}
	return total;
}

//----------------------------------------------------------------------------------------------------
bool DtEditArray::requireRedraw(void)
{
	bool redraw = false;
	for(int i = 0; i < getN(); i++)
		if(edit[i]->requireRedraw()) redraw = true;
	return redraw;
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::drawText(CDC *dc, CPoint p)
{
	for(int i = 0; i < edit.size(); i++) {
		edit[i]->drawText(dc, p);
		p.x += sz[i].cx;
	}
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::drawCursor(CDC *dc, CPoint p)
{
	for(int i = 0; i < edit.size(); i++) {
		edit[i]->drawCursor(dc, p);
		p.x += sz[i].cx;
	}
}

//----------------------------------------------------------------------------------------------------
void DtEditArray::cursorVisible(bool v)
{
	cursor_visible = v;
	if(cursor_visible) {
		for(int i=0; i<edit.size(); i++)
			edit[i]->cursorVisible(i == active_edit);
	}
	else {
		for(int i=0; i<edit.size(); i++)
			edit[i]->cursorVisible(false);
	}
}

//----------------------------------------------------------------------------------------------------
bool DtEditArray::prevEdit()
// return true if we had to actually wrap back to the final edit
{
	bool r=false; // true if we wrapped
	int n=active_edit;

	do {
		if(n<=0) { n=getN()-1; r=true; }
		else n--;
		if(n == active_edit) break;
	} while(skip_edit[n]);

	setActiveN(n);
	active().selectAll(true);
	return r;

}

//----------------------------------------------------------------------------------------------------
bool DtEditArray::nextEdit()
// return true if we had to wrap back to the first edit
{
	bool r=false; // true if we wrapped
	int n = active_edit;
	do {
		if(n>=getN()-1) { n=0; r=true; }
		else n++;
		if(n == active_edit) break;
	} while(skip_edit[n]);

	setActiveN(n);
	active().selectAll(false);
	return r;
}


//----------------------------------------------------------------------------------------------------
void DtEditArray::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
// handle a key press
{
	bool pass_key = true; // whether to give the key to the active edit

	// initialize key flags
	flags[FLAG_KEY_EDIT_CHANGE] = false;
	flags[FLAG_KEY_PREV_WRAP] = false;
	flags[FLAG_KEY_NEXT_WRAP] = false;

	bool shift_state = GetKeyState(VK_SHIFT)&0x80?1:0;

	// check whether we should activate another edit instead	
	if(!shift_state) switch(nChar) {
	case VK_HOME:
	case VK_LEFT:
		if(active().isCursorHome()) {
			flags[FLAG_KEY_EDIT_CHANGE] = true;
			flags[FLAG_KEY_PREV_WRAP] = prevEdit();
			pass_key = false;
		}
		break;

	case VK_RIGHT:
	case VK_END:
		if(active().isCursorEnd()) {
			flags[FLAG_KEY_EDIT_CHANGE] = true;
			flags[FLAG_KEY_NEXT_WRAP] = nextEdit();
			pass_key = false;
		}
		break;
	}

	// we didn't gobble the key stroke so pass it to the active edit
	if(pass_key)
		active().doKeyDown(nChar, nRepCnt, nFlags);

	// if we got the key stroke then the cursor must be visible
	cursorVisible(true);
}
