#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <windows.h>
#include <commctrl.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "mmsystem.h"

#include "mdk.h"
CMachineParameter const paraS = {pt_byte,"ScopeAlpha","ScopeAlpha",0,128,255,MPF_STATE,128};
CMachineParameter const paraP = {pt_byte,"PhaseAlpha","PhaseAlpha",0,128,255,MPF_STATE,0};


CMachineParameter const *pParameters[] = 
{ 
	&paraS,
	&paraP
};

#pragma pack(1)		


class gvals  
{
public:
	byte S;
	byte P;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,								// type
	MI_VERSION,	
	MIF_DOES_INPUT_MIXING,					// flags
	0,										// min tracks
	0,										// max tracks
	2,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	NULL,
	"Zephod Scope",								// TIME / DATE
	"Scope",								// short name
	"Zephod",						// author
	"Open Scope"
};

class miex : public CMDKMachineInterfaceEx {};

HINSTANCE dllInstance;
#define BUFLEN 128

#define  NEARCLIP    0.0f
#define  FARCLIP     1024.0f
#define  FOVA        90.0f

// Texture width / Height (Actually just our "Window" width / height (it WAS a texture a long time ago))
#define TW    256
#define TH    256

/*************************************************************/

// Machine Interface
class mi : public CMDKMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Tick();

	virtual void MDKInit(CMachineDataInput * const pi);
	virtual bool MDKWork(float *psamples, int numsamples, int const mode);
	virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	virtual void SetNumTracks(int const n) { numTracks = n; }

	virtual void Stop();
	virtual void Command(int const i);
	
	virtual void MDKSave(CMachineDataOutput * const po);

	virtual char const *DescribeValue(int const param, int const value);

public:
	virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
	virtual void OutputModeChanged(bool stereo) {}


public:
	miex ex;

	long TickCalls;
	long SampsCalled;


	int numTracks;
	gvals gval;
	HWND GlWindow;
	HDC hDC;
	HGLRC hRC;
float lbuf[BUFLEN+3];
float rbuf[BUFLEN+3];
int pos;

// Globals, will put in class when this all actually works :()
// Global window handles

// Global opengl translate / rotate vars
float XltX ;
float XltY ;
float XltZ ;

float RotX;
float RotY;
float RotZ;
HWND getHWnd();
float scopealpha, phasealpha;
UINT timer;
void closewnd();
};

static mi** mis=NULL;

static int misCount=0;

HINSTANCE ThisApp;