#
# master & servant 1.0
#
# assign a slave and master (gen, effect, vst, whatever). Do not assign 
# anything to THRESHOLD (at least not until u understand whats goin on).
# When the value of master (1-byte) goes above the threshold value (2-byte)
# the value of the slave (0-byte) will rise accordingly.
#
# mute at plosive dot net
#

from buzz import *


thresh=80			#default threshold value for cutoff to amp	
SendPeerCtrlChange(2,1,thresh)	#set default threshold


def mMAX(num):

	mach = GetPeerCtrlTarget(num)
	tar = mach[2]
	y = GetMachineInfo (mach[0])
	z = UnpackMachineInfo(y)
	m = z[10] 	#realname			
	p = z[7] 	#paramlist			
	named = GetMachineName(mach[0]) 
	mac = p[tar][4]
	pnamed = p[tar][1]

	return (mac, pnamed)

def servant(track,index,value):

	results = mMAX(0)			
	max = results[0]
	pname = results[1]

	diff = float(max / 128.0)
	value = value * diff		
	
	SendPeerCtrlChange(track,index,value)

def master(track,index,value):
	
	results = mMAX(1)			
	max = results[0]
	pname = results[1]

	diff = float(max / 128.0)
	value = value * diff		

	SendPeerCtrlChange(track,index,value)

	
def OnParameter(track,index,value):

	global thresh
	
	if (index == 1 and track == 0):	
		
		if (value < thresh): servant(0,1,0)

		servant(track,index,value)

	if (index == 1 and track == 1):	

		if (value > thresh): servant(0,1,value)
		
		if (value < thresh): servant(0,1,0)

		master(track,index,value)

	if (index == 1 and track == 2):	thresh = value

SetEventTarget("OnParameter",OnParameter)

SetPeerCtrlName(0,"Slave")
SetPeerCtrlName(1,"Master")
SetPeerCtrlName(2,"Threshold")
